<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--
	consolidatedTableOutput.8g.xsl   2012-06-15T09
	LIsts <xid> elements in <*_codeOutput.*.xml> into consolidated html table.
	Paul Schluter, GE Healthcare
	- - -
	Outputs html file containing expanded REFID strings, PART, CODE10 and CF_CODE10 values.
	The first base term of each file and expanded discriminators (if any) are highlighted in light grey.
	- - -
	LIMITATIONS:
	1.	Currently uses a modulus test to determine whether a term is a "base term" or not.
		Does not work for MDC_ECG_HEART_RATE (CODE10=16770) since it is not divisible by four,
		MDC_ECG_HEART_RATE_MIN (CODE10=16772) is listed instead (which is correct, but is not
		the desired MDC_ECG_HEART_RATE, so the consolidated output file was manually edited.)
	- - -
	-->
	<xsl:output method="html"/>
	<!-- List of files to be processed, in order specified, with disciminator modulus that is used. -->
	<xsl:variable name="fileNames" as="xs:string+" select="
		'ECG_LEADS_codeOutput.8g.xml 256',
		'ECG_WAVC_codeOutput.8g.xml 64',
		'ECG_WAVP_codeOutput.8g.xml 256',
		'ECG_BEAT_codeOutput.8g.xml 16',		
		'ECG_RHY_codeOutput.8g.xml 16',		
		'ECG_NOISE_codeOutput.8g.xml 16',	
		'ECG_MEAS_GLOBAL_codeOutput.8g.xml 4',
		'ECG_MEAS_perLEAD_codeOutput.8g.xml 256',
		'ECG_LEAD_SYSTEMS_codeOutput.8g.xml 1',
		'ECG_CTL_VBL_codeOutput.8g.xml 1',
		'ECG_INFO_ID_codeOutput.8g.xml 1'
		"/>
	<!-- partition size = 2^16 -->
	<xsl:variable name="partSize" select="65536"/>
	<!-- root template -->
	<xsl:template match="/">
		<html>
			<head>
				<title>
					<xsl:value-of select="'Consolidated List of Annotated ECG Terms'"/>
				</title>
			</head>
			<!-- Output table for all the partition terms -->
			<body>
				<table border="1" cellpadding="2" cellspacing="0">
					<caption align="top">
						<b>
							<xsl:value-of select="/partition/partitionDescription/title"/>
						</b>
					</caption>
					<tbody>
						<tr align="left" bgcolor="D3D3D3">
							<th>REFID</th>
							<th>PART</th>
							<th>CODE10</th>
							<th>CF_CODE10</th>
						</tr>
						<!-- -->
						<xsl:for-each select="$fileNames">
							<xsl:variable name="currentFileName" select="substring-before(string(.),' ')"/>
							<xsl:variable name="discrimMod" select="substring-after(string(.),' ') cast as xs:integer"/>
							<xsl:for-each select="document($currentFileName)">
								<xsl:variable name="firstCode" select="//xid[1]/@code cast as xs:integer"/>
								<xsl:for-each select="/terms/xid">
									<!-- <xsl:variable name="expFlag" select="1"/> -->  <!-- enable this statement to list all expanded terms -->
									<xsl:variable name="expFlag" select="(@code cast as xs:integer ge $firstCode) and (@code cast as xs:integer lt ($firstCode + $discrimMod))"/>
									<xsl:if test="((@code mod $discrimMod) = 0) or $expFlag">	
										<xsl:variable name="bgcolor1" select="if ($expFlag and (((@part * $partSize) + @code) ge 256)) then 'E0E0E0' else 'FFFFFF'"/>	
										<tr bgcolor="{$bgcolor1}">
											<td><xsl:value-of select="text()"/></td>
											<td align="right"><xsl:value-of select="@part"/></td>
											<td align="right"><xsl:value-of select="@code"/></td>
											<td align="right"><xsl:value-of select="(@part * $partSize) + @code"/></td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:for-each>
					</tbody>
				</table>
			</body>
		</html>
	</xsl:template>
	<!-- Fin -->
</xsl:stylesheet>
