% Copyright (c) 2016 STMicroelectronics International N.V.
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without modification,
% are permitted provided that the following conditions are met:
% 
% 1. Redistributions of source code must retain the above copyright notice,
%    this list of conditions and the following disclaimer.
% 
% 2. Redistributions in binary form must reproduce the above copyright notice,
%    this list of conditions and the following disclaimer in the documentation
%    and/or other materials provided with the distribution.
% 
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
% THE POSSIBILITY OF SUCH DAMAGE.

function [file_count] = tiff2ppm(ip_folder, op_folder)
% TIFF2PPM - converts tiff files to PPM
%  [file_count] = TIFF2PPM(ip_folder, op_folder)
%
% tiff2ppm('./', './');

    % Add path to source directory
    addpath('../../src');
    
    % Run tests
    file_list  = dir(fullfile(ip_folder, '*.tif'));
    file_count = length(file_list) ;
    
    for fi = 1:file_count

        ip_file  = fullfile(ip_folder, file_list(fi).name);
        fprintf('#%3d/%3d : Reading "%s"\n', fi, file_count, ip_file);
        img_data = imread(ip_file);
        
        [ip_root, ip_base, ip_ext] = fileparts(ip_file);
        op_file = fullfile(op_folder, [ip_base,'.ppm']);
        fprintf('#%3d/%3d : Writing "%s"\n', fi, file_count, op_file);
            
        pnm_writer(op_file, img_data, 65280, 'big_endian', true, 'binary', true);
    end    

end

