% Copyright (c) 2016 STMicroelectronics International N.V.
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
% 1. Redistributions of source code must retain the above copyright notice,
%    this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright notice,
%    this list of conditions and the following disclaimer in the documentation
%    and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its contributors
%    may be used to endorse or promote products derived from this software
%    without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
% THE POSSIBILITY OF SUCH DAMAGE.

function [op_array] = get_matrix(transform_name)
%GET_MATRIX Returns the 3x3 color transform name
%  [op_array] = GET_MATRIX()
%  [op_array] = GET_MATRIX(transform_name)
%
% Description:
% Returns the 3x3 color transform matrix  for the input transform name
% If no transform name is specified the 3x3 identity matrix is returned
%
% See also GET_WHITE_POINT

    if nargin < 1, transform_name = 'identity'; end
    
    % Initialise colour space transforms
    transform_lut = struct ();
    transform_lut.identity        = eye(3);
    transform_lut.XYZ_D65toXYZ_E  = [ 1.0502616 ,0.0270757,-0.0232523;...
                                      0.039065,  0.9729502,-0.0092579;...
                                     -0.0024047,0.0026446, 0.9180873];
    transform_lut.XYZ_D50toXYZ_E  = [ 1.0025535, 0.0036238, 0.0359837;...
                                      0.0096914, 0.9819125, 0.0105947;...
                                      0.0089181,-0.0160789, 1.220877 ];
    transform_lut.RGBtoXYZ_D65    = [ 0.412453, 0.35758,  0.180423;...
                                      0.212671, 0.71516,  0.072169;...
                                      0.019334, 0.119193, 0.950227];
    transform_lut.RGBtoXYZ_E      = [ 0.43846, 0.39219, 0.16940 ;...
                                      0.22279, 0.70872, 0.06849 ;...
                                      0.01729, 0.11045, 0.87221 ];
    transform_lut.XYZ_EtoAC1C2    = [ 0.0000,  1.0000,  0.00000 ;...
                                      1.0000, -1.0000,  0.00000 ;...
                                      0.0000,  0.4000, -0.40000 ];
    transform_lut.AC1C2toXYZ_E    = [ 1.0000,  1.0000,  0.0000 ;...
                                      1.0000,  0.0000,  0.0000 ;...
                                      1.0000,  0.0000, -2.5000 ];
    transform_lut.XYZ_EtoXYZ_D65  = [ 0.95315, -0.02661,  0.02392 ;...
                                     -0.03827,  1.02885,  0.00942 ;...
                                      0.00261, -0.00305,  1.08949 ];
    transform_lut.XYZ_D65toRGB    = [ 3.240479, -1.537150, -0.498535 ;...
                                     -0.969256,  1.875992,  0.041556 ;...
                                      0.055648, -0.204043,  1.057311 ];
                                       
    if isfield(transform_lut, transform_name)
    	op_array = transform_lut.(transform_name);
    else
        valid_transforms = fieldnames(transform_lut);
        error('Unknown Color Transform "%s"!\nValid color transforms:\n%s', transform_name, sprintf('"%s"\n', valid_transforms{:}));
    end
    
end

