% Copyright (c) 2016 STMicroelectronics International N.V.
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
% 1. Redistributions of source code must retain the above copyright notice,
%    this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright notice,
%    this list of conditions and the following disclaimer in the documentation
%    and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its contributors
%    may be used to endorse or promote products derived from this software
%    without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
% THE POSSIBILITY OF SUCH DAMAGE.

function [err_cnt] = check_value(parm_name, actual, expected, tolerance, display_format, delimiter, elapsed_time_sec)

    if nargin < 6, delimiter        = '\n'; end
    if nargin < 7, elapsed_time_sec = 0.0;  end
    
    % Check that the 2 inputs are within the required tolerance
    max_err = 0.0;
    max_err = 0.0;
    err_cnt = 0;
    err_msg = [parm_name,'\n'];
    % Check arrays are the same size
    [ex_height, ex_width] = size(expected);
    [ac_height, ac_width] = size(actual);
    if ac_height == ex_height && ac_width == ex_width
        % Compare line by line
        for row = 1:ex_height
            delta = actual(row,:) - expected(row,:);
            row_err_cnt = sum(abs(delta) > tolerance);
            if row_err_cnt > 0
                row_err_msg = sprintf('ERROR! #%02d:%s\tExpected: (%-28s)%s\tActual:   (%-28s)%s\tDelta:    (%-28s)\n', row, delimiter, sprintf(display_format, expected(row,:)), delimiter, sprintf(display_format, actual(row,:)), delimiter, sprintf(display_format, delta));
                err_msg = [err_msg, row_err_msg];
            end
            err_cnt = err_cnt + row_err_cnt;
        end
        
        % Min / max errors
        max_err = max(max(actual-expected));
        min_err = min(min(actual-expected));
        row_err_msg = sprintf('Min Error: %9.5f, Max Error: %9.5f, Tolerance: %9.5f\n', min_err, max_err, tolerance);
        err_msg = [err_msg, row_err_msg];
        
    else
        err_cnt = 1;
        err_msg = sprintf('%s - ERROR: Size mis-match - Expected: [%s], Actual: [%s]\n', parm_name, sprintf('%4d', size(expected)), sprintf('%4d', size(actual)));
    end
    if err_cnt < 1
        err_msg = sprintf('%s - CHECK OK - %9.4fsec\n%s - Min Err: %9.5f, Max Err: %9.5f, Tol: %9.5f\n', parm_name, elapsed_time_sec, parm_name, min_err, max_err, tolerance);
    end
    fprintf(2, err_msg);

end

