% Copyright (c) 2016 STMicroelectronics International N.V.
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
% 1. Redistributions of source code must retain the above copyright notice,
%    this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright notice,
%    this list of conditions and the following disclaimer in the documentation
%    and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its contributors
%    may be used to endorse or promote products derived from this software
%    without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
% THE POSSIBILITY OF SUCH DAMAGE.

function status = test_all()
%TEST_ALL Runs all functional tests
% TEST_ALL()

    errors = zeros(1,17);

    errors(1)  = test_pnm_reader;
    errors(2)  = test_fft_radial_frequency;
    errors(3)  = test_fft_cross_section;
    errors(4)  = test_xyz_to_cielab;
    errors(5)  = test_xyz_to_cieluv;
    errors(6)  = test_cielab_to_xyz;
    errors(7)  = test_noise_power_spectrum;
    errors(8)  = test_iso_visual_noise_csf;
    errors(9)  = test_jf_scielab_csf;
    errors(10) = test_circular_aperture_mtf;
    errors(11) = test_display_print_mtf;
    errors(12) = test_high_pass_filter;
    errors(13) = test_codes_to_electrons;
    errors(14) = test_electrons_to_codes;
    errors(15) = test_iso_visual_noise_tool;
    errors(16) = test_cpiq_visual_noise_tool;
    errors(17) = test_aptina_visual_noise_tool;

    status = sum(errors);
    if status > 0
        fprintf(2, '\n%s() ERROR! - Functional Tests Failed! - %d Errors\n\n', mfilename, status);
    else
        fprintf(2, '\n%s() SUCCESS! - All Functional Tests OK!\n\n', mfilename);
    end

end