% Copyright (c) 2016 STMicroelectronics International N.V.
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
% 1. Redistributions of source code must retain the above copyright notice,
%    this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright notice,
%    this list of conditions and the following disclaimer in the documentation
%    and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its contributors
%    may be used to endorse or promote products derived from this software
%    without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
% THE POSSIBILITY OF SUCH DAMAGE.

function [status] = test_cielab_to_xyz()

    % Add path to source directory
    addpath('../src');
    
    % Run tests
    errors = zeros(1,2);
    errors(1) = test_component([mfilename,'::ramp01'], 'ramp01_11x1_cielab.csv', 'D65', 'ramp01_11x1_xyz.csv', 0.0005);
    errors(2) = test_component([mfilename,'::ramp02'], 'ramp02_11x1_cielab.csv', 'D65', 'ramp02_11x1_xyz.csv', 0.0005);
    
    % Generate status
    status = sum(errors);
    if status > 0
        fprintf(2, '%s() ERROR! - Functional Tests Failed! - %d Errors\n', mfilename, status);
    else
        fprintf(2, '%s() SUCCESS! - All Functional Tests OK!\n', mfilename);
    end
end

function [status] = test_component(check_name, ip_csv_file, white_point, expected_csv_file, tolerance)

    % Input data root
    unit_test_root = './data';
    
    % Run component
    ip_array = get_image_from_csv(fullfile(unit_test_root, ip_csv_file), 3);
    tic    
    actual = cielab_to_xyz(ip_array, get_white_point(white_point, 'ISO_VN'));
    elapsed_time_sec = toc;
    
    % Get expected data
    expected = get_image_from_csv(fullfile(unit_test_root, expected_csv_file), 3);
    
    % Run checks
    status = check_value([check_name,'.xyz'], actual, expected, tolerance, '%.4f. ', ' ', elapsed_time_sec); 
end