% Copyright (c) 2016 STMicroelectronics International N.V.
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
% 1. Redistributions of source code must retain the above copyright notice,
%    this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright notice,
%    this list of conditions and the following disclaimer in the documentation
%    and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its contributors
%    may be used to endorse or promote products derived from this software
%    without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
% THE POSSIBILITY OF SUCH DAMAGE.

function [status] = test_cpiq_visual_noise_tool()
% TEST_CPIQ_VISUAL_NOISE_TOOL - CPIQ Visual Noise Tool functional tests
%   TEST_CPIQ_VISUAL_NOISE_TOOL()

    % Add path to source directory
    addpath('../src');
    % Run tests
    errors = zeros(1,8);
    errors(1) = test_component([mfilename,'::cpiq_oecf'],     'cpiq_oecf',     '*.ppm', 'rgb',    30.1593, 'old', true, 'covar',   0.4600);
    errors(2) = test_component([mfilename,'::cpiq_oecf'],     'cpiq_oecf',     '*.ppm', 'rgb',    30.1593, 'old', true, 'output',  0.0591);
    errors(3) = test_component([mfilename,'::aptina_icclab'], 'aptina_icclab', '*.ppm', 'icclab', 30.1593, 'old', true, 'debug',   0.0083);
    errors(4) = test_component([mfilename,'::aptina_icclab'], 'aptina_icclab', '*.ppm', 'icclab', 30.1593, 'old', true, 'covar',   0.0083);
    errors(5) = test_component([mfilename,'::aptina_icclab'], 'aptina_icclab', '*.ppm', 'icclab', 30.1593, 'old', true, 'output',  0.0004);
    errors(6) = test_component([mfilename,'::aptina_icclab'], 'aptina_icclab', '*.ppm', 'icclab', 30.1593, 'new', true, 'debug',   0.0710);
    errors(7) = test_component([mfilename,'::aptina_icclab'], 'aptina_icclab', '*.ppm', 'icclab', 30.1593, 'new', true, 'covar',   1.2270);
    errors(8) = test_component([mfilename,'::aptina_icclab'], 'aptina_icclab', '*.ppm', 'icclab', 30.1593, 'new', true, 'output',  0.0770);
    % Generate status
    status = sum(errors);
    if status > 0
        fprintf(2, '%s() ERROR! - Functional Tests Failed! - %d Errors\n', mfilename, status);
    else
        fprintf(2, '%s() SUCCESS! - All Functional Tests OK!\n', mfilename);
    end
end

function [status] = test_component(check_name, image_src, ip_pattern, image_type, cycles_per_degree, radial_mode, high_pass_filter, check_type, tolerance)
% TEST_COMPONENT - functional test wrapper

    % Input data root
    unit_test_root = '../images';
    % Run component
    tic
    [actual, col_labels, row_labels] = cpiq_visual_noise_tool(fullfile(unit_test_root, image_src,  ip_pattern), ...
                                                              'image_type',        image_type, ...
                                                              'cycles_per_degree', cycles_per_degree, ...
                                                              'radial_mode',       radial_mode, ...
                                                              'high_pass_filter',  high_pass_filter, ...
                                                              'stats_return_type', check_type);
    elapsed_time_sec = toc;
    
    % Build file names
    expected_csv_file = sprintf('%s_cpiq_vn_%s_expected.csv',  image_src, check_type);
    actual_csv_file   = sprintf('%s_cpiq_vn_%s_%s_actual.csv', image_src, radial_mode, check_type);
    
    % Get expected data
    expected = csvread(fullfile(unit_test_root, image_src, expected_csv_file), 1, 1);

    status = check_value([check_name,'::',check_type], actual, expected, tolerance, '%.4f. ', '\t', elapsed_time_sec);
    
    table_writer(fullfile(unit_test_root, image_src, actual_csv_file), ...
                 actual,  col_labels,  row_labels, ...
                 'delimiter', ',', ...
                 'precision', 8, ...
                 'col_width', 0);
    
end