% Copyright (c) 2016 STMicroelectronics International N.V.
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
% 1. Redistributions of source code must retain the above copyright notice,
%    this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright notice,
%    this list of conditions and the following disclaimer in the documentation
%    and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its contributors
%    may be used to endorse or promote products derived from this software
%    without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
% THE POSSIBILITY OF SUCH DAMAGE.

function [status] = test_display_print_mtf()
%TEST_DISPLAY_PRINT_MTF - Display/Print MTF functional tests

    % Add path to source directory
    addpath('../src');
    
    % Run tests
    errors = zeros(1,1);
    errors(1) = test_component([mfilename,'::64::apple'], 64, 1.0, 'expected_apple_display_mtf_64x64.csv', 0.00010);
  
    % Generate status
    status = sum(errors);
    if status > 0
        fprintf(2, '%s() ERROR! - Functional Tests Failed! - %d Errors\n', mfilename, status);
    else
        fprintf(2, '%s() SUCCESS! - All Functional Tests OK!\n', mfilename);
    end
    
end

function [status] = test_component(check_name, image_size, freq_scale_factor, expected_csv_file, tolerance)
%TEST_COMPONENT - functional test wrapper

    % Input data root
    unit_test_root = './data/display_print_mtf';
    
    % Run component
    tic
    ip_array = ones(image_size, image_size, 3);
    
    % Get component output
    op_array = display_print_mtf(ip_array, ...
                                'freq_scale_factor',   freq_scale_factor, ...
                                'radial_mode',         'new');
                                
    % Get cross section                   
    actual = fft_cross_section(op_array, ...
                               'xsection_type',       'hori', ...
                               'freq_scale_factor',   freq_scale_factor, ...
                               'radial_mode',        'new');
                           
    elapsed_time_sec = toc;
    
    % Get expected data
    expected = csvread(fullfile(unit_test_root, expected_csv_file));
    
    % Run checks
    status = check_value(check_name, actual, expected, tolerance, '%.4f. ', '\t', elapsed_time_sec);

end