% Copyright (c) 2016 STMicroelectronics International N.V.
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
% 1. Redistributions of source code must retain the above copyright notice,
%    this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright notice,
%    this list of conditions and the following disclaimer in the documentation
%    and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its contributors
%    may be used to endorse or promote products derived from this software
%    without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
% THE POSSIBILITY OF SUCH DAMAGE.

function [status] = test_electrons_to_codes()
%TEST_ELECTRONS_TO_CODES - Electrons to Codes functional tests

    % Add path to source directory
    addpath('../src');
    % Run tests
    errors = zeros(1,6);
    errors(1) = test_component([mfilename,'::01'], [627.45, 1254.90, 2509.80], 'RGB',  16, 12, 5000.0,   255.0, [32.0, 64.0, 128.0], 0.001);
    errors(2) = test_component([mfilename,'::02'], [ 78.20,  156.40,  312.81], 'RGB',  16, 12, 2500.0,  1023.0, [32.0, 64.0, 128.0], 0.002);
    errors(3) = test_component([mfilename,'::03'], [  9.77,   19.54,   39.07], 'RGB',  16, 12, 1250.0,  4095.0, [32.0, 64.0, 128.0], 0.014);
    errors(4) = test_component([mfilename,'::04'], [627.45, 1254.90, 2509.80], 'Mono', 16, 12, 5000.0,   255.0, [32.0], 0.001);
    errors(5) = test_component([mfilename,'::05'], [ 78.20,  156.40,  312.81], 'Mono', 16, 12, 2500.0,  1023.0, [32.0], 0.001);
    errors(6) = test_component([mfilename,'::06'], [  9.77,   19.54,   39.07], 'Mono', 16, 12, 1250.0,  4095.0, [32.0], 0.007);
    % Generate status
    status = sum(errors);
    if status > 0
        fprintf(2, '%s() ERROR! - Functional Tests Failed! - %d Errors\n', mfilename, status);
    else
        fprintf(2, '%s() SUCCESS! - All Functional Tests OK!\n', mfilename);
    end

end

function [status] = test_component(check_name, value, data_type, width, height, max_signal_e, op_nominal_white, expected, tolerance)
%TEST_COMPONENT - functional test wrapper

    % Create input test image
    ip_array = get_ip_image(value, data_type, width, height);
   
    % Run component
    tic     
    [actual, dummy] = electrons_to_codes(ip_array, 'max_signal_e', max_signal_e, 'op_nominal_white', op_nominal_white);
    elapsed_time_sec = toc;
    
    % Reshape actual
    actual_means = zeros(1, size(actual, 3));
    for ci=1:size(actual, 3)
        actual_means(ci) = mean(mean((actual(:,:,ci))));
    end
    
    % Run checks
    status = check_value(check_name, actual_means, expected, tolerance, '%.4f. ', '\t', elapsed_time_sec); 

end

function [op_array] = get_ip_image(value, data_type, width, height)
%GET_IP_IMAGE - returns input image

    switch(lower(data_type))
        case {'mono'}
            op_array = value(1) * ones(height, width);
        otherwise
            op_array = ones(height, width, 3);
            for ci=1:3
                 op_array(:,:,ci) = op_array(:,:,ci) .* value(ci);
            end
    end

end