% Copyright (c) 2016 STMicroelectronics International N.V.
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
% 1. Redistributions of source code must retain the above copyright notice,
%    this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright notice,
%    this list of conditions and the following disclaimer in the documentation
%    and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its contributors
%    may be used to endorse or promote products derived from this software
%    without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
% THE POSSIBILITY OF SUCH DAMAGE.

function [status] = test_fft_cross_section()
%TEST_FFT_CROSS_SECTION - FFT cross section functional tests

    % Add path to source directory
    addpath('../src');
    
    % Run tests
    errors = zeros(1,6);
    errors(1) = test_component(mfilename, 'cone_16x16_test_ip.csv', 'hori', 1.0, 'new', 'cone_16x16_expected_op_hori.csv', 0.0001);
    errors(2) = test_component(mfilename, 'cone_16x16_test_ip.csv', 'vert', 1.0, 'new', 'cone_16x16_expected_op_vert.csv', 0.0001);
    errors(3) = test_component(mfilename, 'cone_32x32_test_ip.csv', 'hori', 1.0, 'new', 'cone_32x32_expected_op_hori.csv', 0.0001);
    errors(4) = test_component(mfilename, 'cone_32x32_test_ip.csv', 'vert', 1.0, 'new', 'cone_32x32_expected_op_vert.csv', 0.0001);
    errors(5) = test_component(mfilename, 'cone_8x4_test_ip.csv',   'hori', 1.0, 'new', 'cone_8x4_expected_op_hori.csv',   0.0001);
    errors(6) = test_component(mfilename, 'cone_8x4_test_ip.csv',   'vert', 1.0, 'new', 'cone_8x4_expected_op_vert.csv',   0.0001);
    
    % Generate status
    status = sum(errors);
    if status > 0
        fprintf(2, '%s() ERROR! - Functional Tests Failed! - %d Errors\n', mfilename, status);
    else
        fprintf(2, '%s() SUCCESS! - All Functional Tests OK!\n', mfilename);
    end
    
end

function [status] = test_component(check_name, ip_file, xsection_type, freq_scale_factor, radial_mode, expected_csv_file, tolerance)
%TEST_COMPONENT - functional test wrapper

    % Input data root
    unit_test_root = './data/fft_cross_section';
    
    % Run component
    tic
    ip_array = csvread(fullfile(unit_test_root, ip_file));
    actual   = fft_cross_section(ip_array, ...
                                 'xsection_type',       xsection_type, ...
                                 'freq_scale_factor',   freq_scale_factor, ...
                                 'radial_mode',         radial_mode);
    elapsed_time_sec = toc;
    
    % Get expected data
    expected = csvread(fullfile(unit_test_root, expected_csv_file));
    
    % Run checks
    status = check_value([check_name,'::',ip_file,'::',xsection_type], actual, expected, tolerance, '%.4f. ', '\n', elapsed_time_sec);
    
end