% Copyright (c) 2016 STMicroelectronics International N.V.
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
% 1. Redistributions of source code must retain the above copyright notice,
%    this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright notice,
%    this list of conditions and the following disclaimer in the documentation
%    and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its contributors
%    may be used to endorse or promote products derived from this software
%    without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
% THE POSSIBILITY OF SUCH DAMAGE.

function [status] = test_noise_power_spectrum()
% TEST_NOISE_POWER_SPECTRUM - Noise Power Spectrum functional tests
%   TEST_NOISE_POWER_SPECTRUM()

    % Add path to source directory
    addpath('../src');
    % Run tests
    errors = zeros(1,4);
    errors(1)  = test_component([mfilename,'::0p000'], 'gaussian_noise_color_beta_0p000', 64, 'global', false, 'hori',  0.0078);
    errors(2)  = test_component([mfilename,'::0p000'], 'gaussian_noise_color_beta_0p000', 64, 'global', false, 'vert',  0.0078);
    errors(3)  = test_component([mfilename,'::0p500'], 'gaussian_noise_color_beta_0p500', 64, 'global', false, 'vert',  0.1020);
    errors(4)  = test_component([mfilename,'::1p000'], 'gaussian_noise_color_beta_1p000', 64, 'global', false, 'vert',  0.0160);
    % Generate status
    status = sum(errors);
    if status > 0
        fprintf(2, '%s() ERROR! - Functional Tests Failed! - %d Errors\n', mfilename, status);
    else
        fprintf(2, '%s() SUCCESS! - All Functional Tests OK!\n', mfilename);
    end
end

function [status] = test_component(check_name, image_label, block_size, mean_type, cross_spectra, xsection_type, tolerance)
% TEST_COMPONENT - functional test wrapper

    % Input data root
    image_root     = '../images/synthetic_patches/bmp';
    unit_test_root = './data/noise_power_spectrum';
    
    % Run component
    tic
    ip_base   = sprintf('%s.bmp', image_label);
    ip_array  = imread(fullfile(image_root, ip_base));
    
    % Get component output
    op_array = noise_power_spectrum (ip_array, ...
                                     'block_size',        block_size, ...
                                     'mean_type',         mean_type, ...
                                     'cross_spectra',     cross_spectra);
                                 
    % Get cross section                   
    actual = fft_cross_section(op_array, ...
                               'xsection_type',       xsection_type, ...
                               'freq_scale_factor',   1.0, ...
                               'radial_mode',         'old');
 
    elapsed_time_sec = toc;
        
    % Get expected data
    ip_base  = sprintf('%s_nps_blk_size_%d_%s.csv', image_label, block_size, xsection_type);
    expected = csvread(fullfile(unit_test_root, ip_base), 1, 1);
    status = check_value(check_name, actual, expected(:,1:4), tolerance, '%.4f. ', '\t', elapsed_time_sec); 
    
end