function Config=LcaGuiCreateInputCropPanel( Config, panelLocation )
% Config=LcaGuiCreateInputCropPanel( Config, panelLocation )
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics
 

    Config.CropEnable  = uint16(    0 );
    Config.CropXOff    = uint16(    0 );
    Config.CropYOff    = uint16(    2);
    Config.CropWidth   = uint16( 2064 );
    Config.CropHeight  = uint16( 1544 );
    
    % Create Panel for loading Image and Config Files
    ph = uipanel('Parent', Config.handles.gui,...
                 'Title','Input Crop',...
                 'Units','normalized',...
                 'Position', panelLocation );
    
    % Calculate width
    columns = 4;
    x_border = 0.02;
    width   = (1.00 - (x_border * double(columns+1))) / double(columns);
    x_repeat = width + x_border;
    rows     = 3;
    y_border = 0.05;
    height   = (1.00 - (y_border * double(rows+1))) / double(rows);
    y_repeat = height + y_border;

    % Add Input Crop enable check box  
    x = x_border + x_repeat*0;
    y = y_border + y_repeat*2;
    Config.handles.crop_enable = uicontrol(ph, 'Style',  'checkbox',...
                                             'String', 'Enable',...
                                             'Min', 0, 'Max', 1,...
                                             'Value', Config.CropEnable,...
                                             'HorizontalAlignment', 'left',...
                                             'Units','normalized',...
                                             'Position',[x+x_border y+0.02 width height]);
    
    % Crop X-Offset Input
    x = x_border + x_repeat * 0;
    y = y_border + y_repeat * 1;
    sth = uicontrol(ph,'Style','text',...
                       'String','XOff',...
                       'HorizontalAlignment', 'left',...
                       'Units','normalized',...
                       'Position',[x y width height]);

    x = x_border + x_repeat * 1;
    valueString = sprintf( '%d', Config.CropXOff );
    Config.handles.crop_xoffset = uicontrol(ph,'Style','edit',...
                                  'String', valueString,...
                                  'HorizontalAlignment', 'right',...
                                  'Units','normalized',...
                                  'Position', [x y width height] );

    % Crop Y-Offset Input
    x = x_border + x_repeat * 2;
    sth = uicontrol(ph,'Style','text',...
                       'String','YOff',...
                       'HorizontalAlignment', 'left',...
                       'Units','normalized',...
                       'Position',[x y width height]);

    x = x_border + x_repeat * 3;
    valueString = sprintf( '%d', Config.CropYOff );
    Config.handles.crop_yoffset = uicontrol(ph,'Style','edit',...
                                       'String', valueString,...
                                       'HorizontalAlignment', 'right',...
                                       'Units','normalized',...
                                       'Position', [x y width height] );

    % Crop Width Input
    x = x_border + x_repeat * 0;
    y = y_border + y_repeat * 0;
    sth = uicontrol(ph,'Style','text',...
                       'String','Width',...
                       'HorizontalAlignment', 'left',...
                       'Units','normalized',...
                       'Position',[x y width height]);

    x = x_border + x_repeat * 1;
    valueString = sprintf( '%d', Config.CropWidth );
    Config.handles.crop_width = uicontrol(ph,'Style','edit',...
                                  'String', valueString,...
                                  'HorizontalAlignment', 'right',...
                                  'Units','normalized',...
                                  'Position', [x y width height] );

    % Crop Height Input
    x = x_border + x_repeat * 2;
    sth = uicontrol(ph,'Style','text',...
                       'String','Height',...
                       'HorizontalAlignment', 'left',...
                       'Units','normalized',...
                       'Position',[x y width height]);

    x = x_border + x_repeat * 3;
    valueString = sprintf( '%d', Config.CropHeight );
    Config.handles.crop_height = uicontrol(ph,'Style','edit',...
                                       'String', valueString,...
                                       'HorizontalAlignment', 'right',...
                                       'Units','normalized',...
                                       'Position', [x y width height] );
                                   
end

