function Config=LcaGuiCreateLoadPanel( Config, panelLocation )
% Config=LcaGuiCreateLoadPanel( Config )
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    Config.imageFileName  = 'images\image.pgm';
    Config.configFileName = 'config\config.txt';
    Config.ImageWidth     = uint16( 2064 );
    Config.ImageHeight    = uint16( 1544 );
    Config.MaxCode        = uint16( 1023 );
    Config.Pedestal       = uint16(   64 );
    Config.Bitshift       = double(    0 );
    Config.Endian         = uint16(    1 );
    
    % Create Panel for loading Image and Config Files
    ph = uipanel('Parent', Config.handles.gui,...
                 'Title','Load',...
                 'Units','normalized',...
                 'Position', panelLocation );
    
    % Calculate width
    columns = 4;
    x_border = 0.02;
    width   = (1.00 - (x_border * double(columns+1))) / double(columns);
    x_repeat = width + x_border;
    rows     = 4;
    y_border = 0.04;
    height   = (1.00 - (y_border * double(rows+1))) / double(rows);
    y_repeat = height + y_border;

    % Add Save Buttons   
    x = x_border + x_repeat * 0;
    y = y_border + y_repeat * 3;
    Config.handles.load_image  = uicontrol(ph, 'Style',  'pushbutton',...
                                             'String', 'Image',...
                                             'HorizontalAlignment', 'center',...
                                             'Units','normalized',...
                                             'Position',[x y width*2 height+y_border],...
                                             'Tag',      'LoadImageFile',...
                                             'Callback', {@LcaLoadImageFileCallback,Config.handles.gui} );

    % Add Load Config File Buttons   
    x = x_border + x_repeat * 2;
    y = y_border + y_repeat * 3;
    Config.handles.load_config = uicontrol(ph, 'Style',  'pushbutton',...
                                             'String', 'Config',...
                                             'HorizontalAlignment', 'center',...
                                             'Units','normalized',...
                                             'Position',[x y width*2 height+y_border],...
                                             'Tag',      'LoadConfigFile',...
                                             'Callback', {@LcaLoadConfigFileCallback,Config.handles.gui} );
                                         
    
    % Image Width Input
    x = x_border + x_repeat * 0;
    y = y_border + y_repeat * 2;
    sth = uicontrol(ph,'Style','text',...
                       'String','Width',...
                       'HorizontalAlignment', 'left',...
                       'Units','normalized',...
                       'Position',[x y width height]);

    x = x_border + x_repeat * 1;
    valueString = sprintf( '%d', Config.ImageWidth );
    Config.handles.image_width = uicontrol(ph,'Style','edit',...
                                  'String', valueString,...
                                  'HorizontalAlignment', 'right',...
                                  'Units','normalized',...
                                  'Position', [x y width height] );

    % Image Height Input
    x = x_border + x_repeat * 2;
    y = y_border + y_repeat * 2;
    sth = uicontrol(ph,'Style','text',...
                       'String','Height',...
                       'HorizontalAlignment', 'left',...
                       'Units','normalized',...
                       'Position',[x y width height]);

    x = x_border + x_repeat * 3;
    valueString = sprintf( '%d', Config.ImageHeight );
    Config.handles.image_height = uicontrol(ph,'Style','edit',...
                                       'String', valueString,...
                                       'HorizontalAlignment', 'right',...
                                       'Units','normalized',...
                                       'Position', [x y width height] );
                                   
    y = 0.1;
                              
    % Max Code Input
    x = x_border + x_repeat * 0;
    y = y_border + y_repeat * 1;
    sth = uicontrol(ph,'Style','text',...
                       'String','Max Code',...
                       'HorizontalAlignment', 'left',...
                       'Units','normalized',...
                       'Position',[x y width height]);

    x = x_border + x_repeat * 1;
    valueString = sprintf( '%d', Config.MaxCode );
    Config.handles.max_code = uicontrol(ph,'Style','edit',...
                                         'String', valueString,...
                                         'HorizontalAlignment', 'right',...
                                         'Units','normalized',...
                                         'Position', [x y width height] );
    % Pedestal Input
    x = x_border + x_repeat * 2;
    y = y_border + y_repeat * 1;
    sth = uicontrol(ph,'Style','text',...
                       'String','Pedestal',...
                       'HorizontalAlignment', 'left',...
                       'Units','normalized',...
                       'Position',[x y width height]);

    x = x_border + x_repeat * 3;
    valueString = sprintf( '%d', Config.Pedestal );
    Config.handles.pedestal = uicontrol(ph,'Style','edit',...
                                         'String', valueString,...
                                         'HorizontalAlignment', 'right',...
                                         'Units','normalized',...
                                         'Position', [x y width height] );
                                     
    % BitShift Input
    x = x_border + x_repeat * 0;
    y = y_border + y_repeat * 0;
    sth = uicontrol(ph,'Style','text',...
                       'String','Bitshift',...
                       'HorizontalAlignment', 'left',...
                       'Units','normalized',...
                       'Position',[x y width height]);

    x = x_border + x_repeat * 1;
    valueString = sprintf( '%.0f', Config.Bitshift );
    Config.handles.bitshift = uicontrol(ph,'Style','edit',...
                                         'String', valueString,...
                                         'HorizontalAlignment', 'right',...
                                         'Units','normalized',...
                                         'Position', [x y width height] );
    % Endian Input
    x = x_border + x_repeat * 2;
    y = y_border + y_repeat * 0;
    sth = uicontrol(ph,'Style','text',...
                       'String','Endian',...
                       'HorizontalAlignment', 'left',...
                       'Units','normalized',...
                       'Position',[x y width height]);

    x = x_border + x_repeat * 3;
    valueString = sprintf( '%d', Config.Endian );
    Config.handles.endian = uicontrol(ph,'Style','edit',...
                                       'String', valueString,...
                                       'HorizontalAlignment', 'right',...
                                       'Units','normalized',...
                                       'Position', [x y width height] );

end
