function Config=LcaGuiCreateResultsPanel( Config, panelLocation )
% Config=LcaGuiCreateResultsPanel( Config, panelLocation )
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   25 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    Config.Results = zeros( 5, 1 );
    [row_count col_count] = size( Config.Results );
                       
    % Create Panel for Results Values
    ph = uipanel('Parent', Config.handles.gui,...
                 'Title','Results',...
                 'Units','normalized',...
                 'Position', panelLocation );
    
    % Calculate width and height
    columns = col_count+1;
    x_border = 0.02;
    width    = (1.00 - (x_border * double(columns+1))) / double(columns);
    x_repeat = width + x_border;
    rows     = row_count;
    y_border = 0.03;
    height   = (1.00 - (y_border * double(rows+1))) / double(rows);
    y_repeat = height + y_border;

    title = { 'Median Dot Diameter',...
              'Dot Tolerance',...
              'Min Dot Diameter',...
              'Mean Dot Diameter',...
              'Max Dot Diameter'};
    
    for row=1:row_count
        
        x = x_border + x_repeat *  0;
        y = y_border + y_repeat * (row_count-row);
        sth = uicontrol(ph,'Style','text',...
                           'String', char(title(row)),...
                           'HorizontalAlignment', 'left',...
                           'Units','normalized',...
                           'Position',[x y width height]);
                       
        for col=1:col_count
            
            x = x_border + x_repeat *  col;
            y = y_border + y_repeat * (row_count-row);        
            colorMatrixValueString = sprintf( '%.3f', Config.Results(row,col) );            
            Config.handles.results(row,col) = uicontrol(ph,'Style','edit',...
                                                   'String', colorMatrixValueString,...
                                                   'HorizontalAlignment', 'right',...
                                                   'Units','normalized',...
                                                   'Position', [x y width height] );
        end
    end

end
