function LcaLoadConfigFileCallback( src, event, figure_handle )
% LcaLoadConfigFileCallback( src, event, figure_handle  )
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

	% Get Config data structure
	Config = get( figure_handle, 'UserData' );
    logFileId = 1;
    
    % Prompt User for Image File Name
    [FileName, FilePath] = uigetfile( {'*.txt'}, 'Load Config File', Config.configFileName );
    if isequal(FileName,0)
        fprintf( logFileId, 'User cancelled Load Config File Operation\n' );
    else
        Config.configFileName = fullfile( FilePath, FileName );
        Config = LcaReadConfigFile( Config, logFileId );
        LcaUpdateGuiParameters( Config, logFileId );                  
    end
    
	% Save Config data structure
	set( figure_handle, 'UserData', Config );
 
end
