function LcaLoadImageFileCallback( src, event, figure_handle )
% LcaLoadImageFileCallback( src, event, figure_handle )
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

	% Get Config data structure
	Config = get( figure_handle, 'UserData' );
    logFileId = 1;
    
    % Prompt User for Image File Name
    [FileName, FilePath] = uigetfile( {'*.*';'*.pgm';'*.raw';'*.bmp'}, 'Load Image File', Config.imageFileName );
    if isequal(FileName,0)
        fprintf( logFileId, 'User cancelled Load Image File Operation\n' );
    else
        Config.imageFileName = fullfile( FilePath, FileName );
        Config = LcaReadGuiParameters( Config, logFileId );
        Config = LcaProcessImage( Config, logFileId );
        LcaUpdateGuiParameters( Config, logFileId );            
    end
    
	% Save Config data structure
	set( figure_handle, 'UserData', Config );
 
end
 
