function Config=LcaReadConfigFile( Config, logFileId ) 
% Config=LcaReadConfigFile( Config, logFileId )
%
% Example(s):
%
% ReadConfigFile( Config );
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % If logFileId not specified then set to 1 (stdout)
    if nargin < 2, logFileId = 1; end

    % Attempt to open script file
    fid = fopen( Config.configFileName, 'rt' );
    
    if fid > -1
        fprintf( logFileId, '%%%% Read Config File = "%s"\n', Config.configFileName );
        
        % Reading ASCII script file
        while 1
            tline = fgetl( fid );
            if ~ischar(tline), break, end
            
            % Remove comments
            tline = regexprep( tline, '%%.*', '' );
            
            % Process Parameter definitions
            [tokens names] = regexpi( tline, 'Config\.(?<name>[a-zA-Z0-9_(),]+)\W+(?<type>\w+)[() \t]+(?<value>[0-9\-\.]+)', 'tokens', 'names' );

            if ~isempty(tokens)
                
                parameterName  = names.name;
                parameterType  = names.type;
                parameterValue = str2double( names.value );

                rowIndex = 0;
                colIndex = 0;
                    
                [tokens names] = regexpi( parameterName, '(?<name>[a-zA-Z0-9]+)\((?<row>\d+),(?<column>\d+)\)', 'tokens', 'names' );
                if ~isempty(tokens)
                    parameterName  = names.name;
                    rowIndex       = uint16( str2double( names.row   ) );
                    colIndex       = uint16( str2double( names.column ) );
                end

                [tokens names] = regexpi( parameterName, '(?<name>[a-zA-Z0-9]+)\((?<row>\d+)\)', 'tokens', 'names' );
                if ~isempty(tokens)
                    parameterName  = names.name;
                    rowIndex       = uint16( str2double( names.row   ) );
                    colIndex = 0;
                end

                if rowIndex > 0 && colIndex > 0
                    
                    nameString = sprintf( '%s(%d,%d)', parameterName, rowIndex, colIndex );
                    switch parameterType
                        case {'double','float'}
                            Config.(parameterName)(rowIndex,colIndex) = double( parameterValue );
                            valueString = sprintf( '%.6f', Config.(parameterName)(rowIndex,colIndex) );
                        otherwise
                            Config.(parameterName)(rowIndex,colIndex) = uint16( parameterValue );
                            valueString = sprintf( '%d', Config.(parameterName)(rowIndex,colIndex) );
                    end
                    
                elseif rowIndex > 0 && colIndex == 0
                    
                    nameString = sprintf( '%s(%d)', parameterName, rowIndex );
                    switch parameterType
                        case {'double','float'}
                            Config.(parameterName)(rowIndex) = double( parameterValue );
                            valueString = sprintf( '%.6f', Config.(parameterName)(rowIndex) );
                        otherwise
                            Config.(parameterName)(rowIndex) = uint16( parameterValue );
                            valueString = sprintf( '%d', Config.(parameterName)(rowIndex) );
                    end
                    
                else
                    
                    nameString = parameterName;
                    switch parameterType
                        case {'double','float'}
                            Config.(parameterName) = double( parameterValue );
                            valueString = sprintf( '%.6f', Config.(parameterName) );
                        otherwise
                            Config.(parameterName) = uint16( parameterValue );
                            valueString = sprintf( '%d', Config.(parameterName) );
                    end
                    
                end
                
                fprintf( logFileId, 'Config.%-40s = %s(%12s);\n', nameString, parameterType, valueString );
                
            end
             
        end
    else
        fprintf( logFileId, 'ERROR! -Failed to Read Config File = "%s"\n', Config.configFileName );
    end

end
