function Config = LcaReadGuiParameters( Config, logFileId )
%Config = LcaReadGuiParameters( Config, logFileId )
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % Read Gui parameters
    Config.ImageWidth  = uint16( str2double( get( Config.handles.image_width,  'String' ) ) );
    Config.ImageHeight = uint16( str2double( get( Config.handles.image_height, 'String' ) ) );
    Config.MaxCode     = uint16( str2double( get( Config.handles.max_code,     'String' ) ) );
    Config.Pedestal    = uint16( str2double( get( Config.handles.pedestal,     'String' ) ) );
    Config.Bitshift    = double( str2double( get( Config.handles.bitshift,     'String' ) ) );
    Config.Endian      = uint16( str2double( get( Config.handles.endian,       'String' ) ) );

    Config.CropEnable = uint16( get( Config.handles.crop_enable, 'Value' ) );
    Config.CropXOff   = uint16( str2double( get( Config.handles.crop_xoffset, 'String' ) ) );
    Config.CropYOff   = uint16( str2double( get( Config.handles.crop_yoffset, 'String' ) ) );
    Config.CropWidth  = uint16( str2double( get( Config.handles.crop_width,   'String' ) ) );
    Config.CropHeight = uint16( str2double( get( Config.handles.crop_height,  'String' ) ) );

end
