function LcaUpdateGuiParameters( Config, logFileId )
% LcaUpdateGuiParameters( Config, logFileId )
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % Update Gui parameters
    set( Config.handles.image_width,  'String', num2str( Config.ImageWidth  ) );
    set( Config.handles.image_height, 'String', num2str( Config.ImageHeight ) );
    set( Config.handles.max_code,     'String', num2str( Config.MaxCode     ) );
    set( Config.handles.pedestal,     'String', num2str( Config.Pedestal    ) );
    set( Config.handles.bitshift,     'String', sprintf( '%.0f', Config.Bitshift ) );
    set( Config.handles.endian,       'String', num2str( Config.Endian    ) );

    set( Config.handles.crop_enable,  'Value',  Config.CropEnable );
    set( Config.handles.crop_xoffset, 'String', num2str( Config.CropXOff    ) );
    set( Config.handles.crop_yoffset, 'String', num2str( Config.CropYOff   ) );
    set( Config.handles.crop_width,   'String', num2str( Config.CropWidth  ) );
    set( Config.handles.crop_height,  'String', num2str( Config.CropHeight ) );

    [rowCount columnCount] = size( Config.Results );
    for row=1:rowCount
        for col=1:columnCount
            colorMatrixValueString = sprintf( '%.3f', Config.Results(row,col) );
            set( Config.handles.results(row,col), 'String', colorMatrixValueString ) ;
        end
    end
    
end
