function lca_dot_plot( figure_title,...
                       xi, yi, input, max_code,...
                       view1, view2, plot_width, plot_height,...
                       input_colour, plotFileName, logFileId )
% lca_dot_plot( fileName, plotFileName )
%
% Plot Input Colour Plane Data
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % If logFileId not specified then set to 1 (stdout)
    if nargin < 8, logFileId = 1; end

    % Replace any underscores with a white space
    figure_title = regexprep( figure_title, '_', ' ');

    % Create Figure plots
    figureHandle = figure('Name',         figure_title,...
                          'NumberTitle',  'off',...
                          'Units',        'pixels',...
                          'DockControls', 'off',...
                          'MenuBar',      'figure',...
                          'Position', [64 64 plot_width plot_height] );
    
    surf( xi, yi, input, 'FaceColor', input_colour, 'EdgeColor','none' );
    
    % Find min/max for plotting
    x_min = min( min( xi ) );
    x_max = max( max( xi ) );
    y_min = min( min( yi ) );
    y_max = max( max( yi ) );
    
    camlight left;
    lighting phong; 
    colormap 'summer';
    xlim( [x_min, x_max] );
    ylim( [y_min, y_max] );
    set(gca,'YDir','reverse');
    zlim( [-0.2, max_code] );
    
    title( figure_title );
    view( view1, view2 );
    hold off
        
    % Export Figure to file
    fprintf( logFileId, 'Exporting figure to "%s"\n', plotFileName );
    
    frame = getframe( figureHandle ); 

    if isempty( frame.colormap )
       imwrite( frame.cdata,  plotFileName, 'png', 'bitdepth', 8 )
    else
       imwrite( frame.cdata,  frame,colormap, plotFileName, 'png', 'bitdepth', 8 );
    end
 
    % Close figure
    close( figureHandle );

end
