function centres=lca_find_centres(	input, xi, yi, max_code,...
                                    roi_list, centreMethod,...
                                    plane_list, plane_colours,...
                                    outputFileRoot, logFileId )
% centres=lca_find_centres(input_image, xi, yi, roi_list, x_image_centre, y_image_centre, logFileId )
%
% Calculates the centre of mass of the dot in the ROI
% Prior to this the ROI data is processed to remove
% the chart background from the calculation.
%
% Input Parameters:
% input_image    = grayscale image data for ROI
% x_index_array = 2D array containing x index data for ROI
%                 must have the same dimensions as input image
% y_index_array = 2D array containing y index data for ROI
%                 must have the same dimensions as input image 
%
% Return Value: 2-D element array containing the dot centres
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % If logFileId not specified then set to 1 (stdout)
    if nargin < 4, logFileId = 1; end
     
    % Determine number of ROI's and image planes
    roi_count   = size( roi_list, 1 );
    plane_count = length(plane_list);
    
    % Initialise centres array
    centres     = double( zeros( roi_count, 2 * plane_count ) );

    % Print column headers
    fprintf( logFileId, '%4s (%4s,%4s)->(%4s,%4s) %5s %8s\n',...
                        'DOT',...
                        'x_ll', 'y_ll', 'x_ur', 'y_ur',...
                        'PLANE', 'DOT CENTRE' );
    
    % Find the centre of mass for each ROI for each colour plane
    for roi=1:roi_count
        
        % Crop image to ROI
        x_ll = roi_list(roi,1);
        y_ll = roi_list(roi,2);
        x_ur = roi_list(roi,3);
        y_ur = roi_list(roi,4);
        
        if roi <= 2 || roi >= roi_count-1
            outputDotPlot = 1;
        else
            outputDotPlot = 0;
        end   

        
             
        % Find centers ...
        for plane_index=1:plane_count;
            
            plane = plane_list(plane_index);            
            img_roi = input( y_ll:y_ur, x_ll:x_ur, plane );
            xi_roi  =    xi( y_ll:y_ur, x_ll:x_ur, plane );
            yi_roi  =    yi( y_ll:y_ur, x_ll:x_ur, plane );

            column_index = (plane_index-1)*2+1;
            column_range =  column_index:column_index+1;
            
            [centres( roi, column_range ), dot] = lca_centre_of_mass_method( img_roi, xi_roi, yi_roi, max_code,...
                                                                             centreMethod, logFileId );
            plot_max_code = 1.2;

                                                        
            roiString     = sprintf( '%5d ', roi_list(roi,:) );
            centresString = sprintf( '%8.3f ', centres(roi, column_range) );
            % fprintf( logFileId, 'DOT %3d: [%s] Plane: %d, Centre: [%s]\n', roi, roiString, plane_index, centresString );
            fprintf( logFileId, '%4d (%4d,%4d)->(%4d,%4d) %5d (%8.3f,%8.3f)\n',...
                                roi,...
                                roi_list(roi,1), roi_list(roi,2), roi_list(roi,3), roi_list(roi,4),...
                                plane_index,...
                                centres(roi, column_index), centres(roi, column_index+1) );
            
            % if outputDotPlot > 0
            %    figure_title = sprintf( 'dot_%04d_plane_%02d_plot.png', roi, plane_index  );
            %    plotFileName = sprintf( '%s_%s', outputFileRoot, figure_title );
            %    lca_dot_plot( figure_title,...
            %           xi_roi, yi_roi, dot, plot_max_code, ...
            %           45, 0, 320, 240,...
            %           plane_colours(plane_index,:), plotFileName, logFileId )
            % end
            
        end
        
    end

end

