function Config = lca_regions_of_interest_plot( Config,...
                                       colour_plane, max_code,...
                                       roi_list,...
                                       logFileId )
% lca_regions_of_interest_plot( figure_title, rgb, roi_list, plotFileName )
%
% Plot Input Colour Plane Data
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % If logFileId not specified then set to 1 (stdout)
    if nargin < 5, logFileId = 1; end

    % Replace any underscores with a white space
    figure_title = regexprep( Config.figureTitleHeader, '_', ' ');

    [plane_height plane_width] = size( colour_plane );
    
    % Create Figure plots
    if ~isfield( Config.handles, 'dot_roi_fig' ) || ~ishandle( Config.handles.dot_roi_fig )
        % Create Figure
        Config.handles.dot_roi_fig = figure( 'Name', Config.figureTitleHeader,...
                                                     'NumberTitle', 'off',...
                                                     'MenuBar',     'figure',...
                                                     'Tag',         'DotRois',...
                                                     'Units',       'pixels',...
                                                     'Position',     [300 200 640 480] );
        % Create Axes for above figure
        Config.handles.dot_roi_axes = axes( 'Parent', Config.handles.dot_roi_fig ); 
    end

    set( 0, 'CurrentFigure', Config.handles.dot_roi_fig );
    set( Config.handles.dot_roi_fig, 'Name', Config.figureTitleHeader );

    % Display image data
    imshow( colour_plane,...
            'DisplayRange', [0 max_code],...
            'Border', 'tight',...
            'InitialMagnification', 100*(640/plane_width),...
            'Parent', Config.handles.dot_roi_axes );
    
    % Overlay ROI and centres
    hold on;
    for roi=1:length(roi_list)
        
        % Extract ROI Information
        x_ll   = roi_list(roi,1);
        y_ll   = roi_list(roi,2);
        x_ur   = roi_list(roi,3);
        y_ur   = roi_list(roi,4);
        x_cent = mean( [x_ll x_ur] );
        y_cent = mean( [y_ll y_ur] );
        
        index_string = sprintf( '%d', roi );
        plot([x_ll x_ll x_ur x_ur x_ll],...
             [y_ll y_ur y_ur y_ll y_ll],...
             'g', 'LineWidth', 2);
        text( x_cent,y_cent,...
              index_string, 'Color', ' r',...
              'FontSize', 8,...
              'FontWeight', 'bold',...
              'HorizontalAlignment', 'Center',...
              'VerticalAlignment', 'Middle' );
    end
    hold off
   
    % Export Figure to file
    fprintf(         1, 'Exporting figure to "%s"\n', Config.plotFileName );
    fprintf( logFileId, 'Exporting figure to "%s"\n', Config.plotFileName );
    
    frame = getframe( Config.handles.dot_roi_fig ); 

    if isempty( frame.colormap )
        imwrite( frame.cdata,  Config.plotFileName, 'png' )
    else
        imwrite( frame.cdata,  frame,colormap, Config.plotFileName, 'png' );
    end
 
    % Close figure
    % close( figureHandle );

end
