function Config = lca_shift_vs_image_height_plot( Config,...
                                         radius, shift, best_fit, max_radius,...
                                         plane_list, gr_plane,...
                                         lineStyle, markerStyle,...
                                         logFileId )
% lca_image_height_vs_shift_plot
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % If logFileId not specified then set to 1 (stdout)
    if nargin < 10, logFileId = 1; end

    % Replace any underscores with a white space
    figure_title = regexprep( Config.figureTitleHeader, '_', ' ');

    % Create Figure plots
    if ~isfield( Config.handles, 'lca_plot_fig' ) || ~ishandle( Config.handles.lca_plot_fig )
        % Create Figure
        Config.handles.lca_plot_fig = figure( 'Name', Config.figureTitleHeader,...
                                                     'NumberTitle', 'off',...
                                                     'MenuBar',     'figure',...
                                                     'Tag',         'LcaPlot',...
                                                     'Units',       'pixels',...
                                                     'Position',     [300 64 640 480] );
        % Create Axes for above figure
        Config.handles.lca_plot_axes = axes( 'Parent', Config.handles.lca_plot_fig ); 
    end

    set( 0, 'CurrentFigure', Config.handles.lca_plot_fig );
    set( Config.handles.lca_plot_fig, 'Name', Config.figureTitleHeader );
    
    for index=1:length(plane_list)
        plane  = plane_list(index);
        line   = char( lineStyle( plane ) );
        marker = char( markerStyle( plane ) );
        % Plot radial error relative to GreenR data and best fit line
        plot( radius(:,gr_plane), shift(:,plane), marker, 'MarkerSize', 6 );
        if index == 1, hold on; end
        plot( (0:max_radius), best_fit(:,plane), line, 'LineWidth', 2 );
    end
    
    title( figure_title );
    xlabel( 'Image Height (pixels)' );
    ylabel( 'LCA in pixels' );
    ylim( [-1.0 1.0] );
    set( gca, 'ytick', [-1.0 -0.8 -0.6 -0.4 -0.2 0 0.2 0.4 0.6 0.8 1.0] );
    set( gca, 'ygrid', 'on' );
    
    hold off

    % Export Figure to file
    fprintf(         1, 'Exporting figure to "%s"\n', Config.plotFileName );
    fprintf( logFileId, 'Exporting figure to "%s"\n', Config.plotFileName );
    
    frame = getframe( Config.handles.lca_plot_fig ); 

    if isempty( frame.colormap )
        imwrite( frame.cdata,  Config.plotFileName, 'png' )
    else
        imwrite( frame.cdata,  frame,colormap, Config.plotFileName, 'png' );
    end
 
    % Close figure
    % close( figureHandle );

end
    
