function output=BayerSplit(input)
% output=BayerSplit(input) - Raw Bayer Colour Plane Split Function
% Raw Bayer CFA
%       G R G R
%       B G B G
%       G R G R
%       B G B G
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics    

    % Get the size of the input array
    [input_height input_width input_planes] = size( input );
    
    % Ensure that BayerSplit Data is a multiple of 2
    corrected_width  = floor( double(input_width )/2.0 ) *2.0;
    corrected_height = floor( double(input_height)/2.0 ) *2.0;
    
    if input_width ~= corrected_width
        fprintf( 2, 'WARNING! - BayerSplit() Width %d not a multiple of 2 setting width to %d\n', input_width, corrected_width );
    end
    if input_height ~= corrected_height
        fprintf( 2, 'WARNING! - BayerSplit() Height %d not a multiple of 2 setting height to %d\n', input_height, corrected_height );
    end
    
    % Determine the colour plane size based on the
    % size of the input raw Bayer data array
    gr_plane = input(1:2:corrected_height,1:2:corrected_width); % Plane GreenR
    rr_plane = input(1:2:corrected_height,2:2:corrected_width); % Plane Red
    bb_plane = input(2:2:corrected_height,1:2:corrected_width); % Plane Blue
    gb_plane = input(2:2:corrected_height,2:2:corrected_width); % Plane GreenB
        
    % split raw bayer image into different colour planes
    % Remember in matlab (y,x) order and indexing starts at zero..
    % matlab advanced array indexing start:step:last
    output = cat( 3, gr_plane, rr_plane, bb_plane, gb_plane);
    
end

