function output=ImageCrop(input, x_offset, y_offset, width, height, logFileId )
% output=ImageCrop(input, x_offset, y_offset, width, height, logFileId )
%
%  Crop input image
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    x_ll = x_offset+1;
    y_ll = y_offset+1;
    x_ur = x_offset+width;
    y_ur = y_offset+height;
    
    [plane_height plane_width plane_count] = size( input );
    
    % Clip input crop window if it lies outwith the image
    if x_ll < 1 
        fprintf( 2, 'WARNING! - ImageCrop() x_ll = %d to low setting x_ll = %d\n', x_ll, 1 );
        x_ll = 1;
    end
    if y_ll < 1 
        fprintf( 2, 'WARNING! - ImageCrop() y_ll = %d to low setting y_ll = %d\n', u_ll, 1 );
        y_ll = 1;
    end
    if x_ur > plane_width
        fprintf( 2, 'WARNING! - ImageCrop() x_ur = %d to low setting x_ur = %d\n', x_ur, plane_width );
        x_ur = plane_width;
    end
    if y_ur > plane_height
        fprintf( 2, 'WARNING! - ImageCrop() y_ur = %d to low setting y_ur = %d\n', y_ur, plane_height );
        y_ur = plane_height;
    end
    
    output = input( y_ll:y_ur, x_ll:x_ur, : );

end
