function RGBImageDiff( ImageFileName1, ImageFileName2, logFileId )
% RGBImageDiff( ImageFileName1, ImageFileName2, logFileId )
%
% The input images must be of the same size and contain at least 2 colour
% planes
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

   % If logFileId not specified then set to 1 (stdout)
   if nargin < 3, logFileId = 1; end
    
   % Read in RGB Image 1
   Image1 = imread( ImageFileName1 );
   
   % Image1 Stats
   for plane=1:3
       min_value = min( min( Image1(:,:,plane ) ) );
       avg_value = mean2( Image1(:,:,plane ) );
       max_value = max( max( Image1(:,:,plane ) ) );
       fprintf( logFileId, 'Plane %d: Min: %.2f, Mean: %.2f, Max: %.2f',...
                   min_value, avg_value, max_value );
   end
   
   % Read in RGB Image 2
   Image2 = imread( ImageFileName2 );

   for plane=1:3
       min_value = min( min( Image2(:,:,plane ) ) );
       avg_value = mean2( Image2(:,:,plane ) );
       max_value = max( max( Image2(:,:,plane ) ) );
       fprintf( logFileId, 'Plane %d: Min: %.2f, Mean: %.2f, Max: %.2f',...
                   min_value, avg_value, max_value );
   end
   
   % Subtract Image 2 from Image 1
   Diff = Image1 - Image2;
   
   % Extract Image Size
   [width height depth]= size( Diff );
   
   % Red difference
   for plane=1:depth
       
       plane_min  = min(min(Diff(:,:,plane)));
       plane_max  = max(max(Diff(:,:,plane)));

       figure, mesh(Diff(:,:,plane)), title( sprintf('Plane %d:', plane') );
       fprintf( logFileId, 'Plane %d: Min = %d, Max = %d', plane, plane_min, plane_max );
 
   end
   
end

