function RawImageDiff( rawFileName1, rawFileName2, logFileId )
% RawImageDiff( ImageFileName1, ImageFileName2, logFileId )
%
% RawImageDiff( 'E:\Local_Share\851_av_images\851_D01\MACBETH\D65\10bit_10frame_out.pgm', 'E:\Local_Share\851_av_images\851_D01\MACBETH\D65\10bit_10frame_av.pgm' )
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

	% If logFileId not specified then set to 1 (stdout)
	if nargin < 3, logFileId = 1; end

	addpath( '..\..\Utils\ImageFileIO' );
   
    % Read in file 1
    fprintf( logFileId, 'READING IN IMAGE 1...\n' );
    [pathstr, name, ext, versn] = fileparts( rawFileName1 );
    switch ext
        case '.pgm'
            % Read ASCII PGM file
            [image1, image_width, image_height, max_code] = ReadPgmFile( rawFileName1, logFileId );
        otherwise
            % Let imread try to read in the file
            image1 = imread( rawFileName1 );
            max_code = 255;
    end
    
    % Image1 Stats
    grbg1 = BayerSplit( image1 );
    
    for plane=1:4
       min_value = min( min( grbg1(:,:,plane ) ) );
       avg_value = mean2( grbg1(:,:,plane ) );
       max_value = max( max( grbg1(:,:,plane ) ) );
       fprintf( logFileId, 'Plane %d: Min: %.2f, Mean: %.2f, Max: %.2f\n',...
                   plane, min_value, avg_value, max_value );
    end
   
    % Read in file 2
    fprintf( logFileId, 'READING IN IMAGE 2...\n' );
    [pathstr, name, ext, versn] = fileparts( rawFileName2 );
    switch ext
        case '.pgm'
            % Read ASCII PGM file
            [image2, image_width, image_height, max_code] = ReadPgmFile( rawFileName2, logFileId );
        otherwise
            % Let imread try to read in the file
            image2 = imread( rawFileName2 );
            max_code = 255;
    end
   
   
   % Read in RGB Image 2
    grbg2 = BayerSplit( image2 );
    
    for plane=1:4
       min_value = min(  min(  grbg2(:,:,plane ) ) );
       avg_value = mean( mean( grbg2(:,:,plane ) ) );
       max_value = max(  max(  grbg2(:,:,plane ) ) );
       fprintf( logFileId, 'Plane %d: Min: %.2f, Mean: %.2f, Max: %.2f\n',...
                   plane, min_value, avg_value, max_value );
    end
   
	% Subtract Image 2 from Image 1
	fprintf( logFileId, 'GENERATING DIFFERENCE IMAGE...\n' );
	Diff = grbg1 - grbg2;
   
   % Red difference
   for plane=1:4
       
       plane_min  = min(min(Diff(:,:,plane)));
       plane_max  = max(max(Diff(:,:,plane)));

       figure, mesh(Diff(:,:,plane)), title( sprintf('Plane %d:', plane') );
       fprintf( logFileId, 'Plane %d: Min = %d, Max = %d\n', plane, plane_min, plane_max );
 
   end
   
end

