function AsciiPgm2BinaryPgm( input_file_name, output_file_name )
% AsciiPgm2BinaryPgm( input_file_name, output_file_name )
%
% Reads in an Binary PGM file and output an ASCII PGM file
%
% Input Parameters:
% input_file_name  = input Ascii Pgm file name
% output_file_name = output Binary Pgm file name
%
% Return Parameters:
% None
%
% Examples:
% BinaryPgm2AsciiPgm( input_file_name, output_file_name )
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % Read in Ascii PGM
    [image, image_width, image_height, max_code] = ReadPgmFile( input_file_name );
    
    % Write Out Binary PGM (pgmType = 5)
    WritePgmFile( image, max_code, output_file_name, 5 )
    
end

