function BinaryPgm2AsciiPgm( input_file_name, output_file_name )
% BinaryPgm2AsciiPgm( input_file_name, output_file_name )
%
% Reads in an Binary PGM file and output an ASCII PGM file
%
% Input Parameters:
% input_file_name  = input Binary Pgm file name
% output_file_name = output Ascii Pgm file name
%
% Return Parameters:
% None
%
% Examples:
% BinaryPgm2AsciiPgm( input_file_name, output_file_name )
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % Read in Binary PGM
    [image, image_width, image_height, max_code] = ReadPgmFile( input_file_name );
    
    % Write Out Ascii PGM (pgmType = 2)
    WritePgmFile( image, max_code, output_file_name, 2 )
    
end

