function SourceFileList = CopyFiles( SourceFileRoot, FileMatchPattern, TargetFileRoot )
%SourceFileList = CopyFiles( SourceFileRoot, FileMatchPattern,, TargetFileRoot )
%
% Performs a recursive file search to find all file with the specified file
% extensions
%
% Input Parameters:
% FileRoot         = FileRoot to start the recusive search
%                    For current directory enter '.\'
% FileMatchPattern = File Name Match Pattern for regexp
%
% Return Value(s):
% FileList = CELL array containing a list of all of the files found
%
% Examples:
%
% CopyFiles( 'M:\ftg\Users\stuart\851_av_images\', '.*10frame.pgm',                  'F:\Local_Share\851_av_images\' );
% CopyFiles( 'M:\ftg\Users\stuart\851_av_images\', '.*10frame_slant_out.pgm',        'F:\Local_Share\851_av_images\' );
% CopyFiles( 'M:\ftg\Users\stuart\851_av_images\', '.*10frame_out.pgm',              'F:\Local_Share\851_av_images\' );
% CopyFiles( 'M:\ftg\Users\stuart\851_av_images\', '.*10frame.*d[0-9]_ped_on.pgm',   'F:\Local_Share\851_av_images\' );
% CopyFiles( 'M:\ftg\Users\stuart\851_av_images\', '.*10frame.*d1_global_ped_on.pgm','F:\Local_Share\851_av_images\' );
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % Define Matlab search paths
    addpath( '..\..\Utils\ImageFileIO' );

    % Build Source File List
    SourceFileList = {};
    SourceFileList = DirectoryFileSearch( SourceFileList, SourceFileRoot, FileMatchPattern );

    % Build Target File List
    fileCount = length( SourceFileList );
    for index=1:fileCount
        SourceFileName = char( SourceFileList( index ) );
        TargetFileName = regexprep( SourceFileName,...
                                    regexptranslate( 'escape', SourceFileRoot ),...
                                    regexptranslate( 'escape', TargetFileRoot ) );
        fprintf( 1, 'Copying "%s" to "%s"\n', SourceFileName, TargetFileName );
        
        % Split File Name to find path
        [pathstr, name, ext, versn] = fileparts( TargetFileName );
        
        % Check that the directory exists if not then create
        if isdir( pathstr ) == 0
            mkdir( pathstr );
        end

        % Copy file
        [status,message,messageid] = copyfile( SourceFileName, TargetFileName );
        
    end

end
