function SourceFileList = DeleteFiles( SourceFileRoot, FileMatchPattern )
%SourceFileList = DeleteFiles( SourceFileRoot, FileMatchPattern )
%
% Performs a recursive file search to find all file with the specified file
% extensions
%
% Input Parameters:
% FileRoot         = FileRoot to start the recusive search
%                    For current directory enter '.\'
% FileMatchPattern = File Name Match Pattern for regexp
%
% Return Value(s):
% FileList = CELL array containing a list of all of the files found
%
% Examples:
%
% DeleteFiles( 'F:\Local_Share\851_av_images\', 'nsp.bmp' );
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % Define Matlab search paths
    addpath( '..\..\Utils\ImageFileIO' );
    addpath( '..\..\Utils\Logger' );
    
    % Build Source File List
    SourceFileList = {};
    SourceFileList = DirectoryFileSearch( SourceFileList, SourceFileRoot, FileMatchPattern );

    % Build Target File List
    fileCount = length( SourceFileList );
    for index=1:fileCount
        SourceFileName = char( SourceFileList( index ) );
        fprintf( 1, 'Deleting file  "%s"', SourceFileName ) );
        % delete file
        delete( SourceFileName );
    end

end
