function fileList = FindFiles( FileRoot, FileMatchPattern )
%fileList = FindFiles( FilePath, FileMatchPattern )
%
% Performs a recursive file search to find all file with the specified file
% extensions
%
% Input Parameters:
% FileRoot         = FileRoot to start the recusive search
%                    For current directory enter '.\'
% FileMatchPattern = File Name Match Pattern for regexp
%
% Return Value(s):
% FileList = CELL array containing a list of all of the files found
%
% Examples:
%
% FileList = {};  % Note MUST be a cell array
% FileList = DirectoryFileSearch( FileList, '.\', '10frame.pgm' );
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % Define Matlab search paths
    addpath( '..\..\Utils\ImageFileIO' );

    fileList = {};
    fileList = DirectoryFileSearch( fileList, FileRoot, FileMatchPattern );

end
