function WriteRawFile( image, max_code, rawFileName, endian, logFileId )
% WriteBinaryRawFile( image, max_code, rawFileName, endian, logFileId  )
%
% Writes a Binary Raw Bayer Image either 8-bit or 16-bit
%
% Input Parameters:
% image        = 2-D image array
%                must be either uint8 or unit16
% max_code     = maximum valid value
%                 8-bit data =  255
%                10-bit data = 1023
% rawFileName  = output Binary Raw file name
% logFileId    = file identifier for logging output (optional)
%                If not specified then logFileId = 1 (stdout)
%
% Return Parameters:
% None
%
% Examples:
% WriteRawFile( image, 'DUT_1_AV_On_D65_10bit_10.bmp_AvgOut.raw', 1 )
%
%  Author: Donald BAXTER, donald.baxter@st.com
%  Date:   24 September 2008
%
%  Copyright (c) 2008 STMicroelectronics

    % If logFileId not specified then set to 1 (stdout)
    if nargin < 4, logFileId = 1; end

    % Attempt to open Binary  Raw Image File
    fid = fopen( rawFileName, 'wb' );
    
    if fid > -1
        
        fprintf( logFileId, 'Writing Raw File "%s"\n', rawFileName );
    
        % transform image
        image = image';

        % Endianess
        machineFormat = 'ieee-be'; % Big Endian
        % machineFormat = 'ieee-le'; % Little Endian

        % Read in raw data
        switch class( image )
            case 'uint16'
                fwrite( fid, image, 'uint16', machineFormat );
            case 'uint8'
                fwrite( fid, image, 'uint8',  machineFormat );
            otherwise
                fprintf( logFileId, 'ERROR! - Unsupported array class = must be either uint8 or uint16 data\n' );
        end
        fclose( fid );

    
    else
        fprintf( logFileId, 'ERROR! - Failed to open Raw File "%s"\n', rawFileName );
    end
    
end

