/* -*- Mode:C++; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 *  Copyright � 2014 by IEEE.
 *
 *  This source file is an essential part of IEEE P1906.1,
 *  Recommended Practice for Nanoscale and Molecular
 *  Communication Framework.
 *  Verbatim copies of this source file may be used and
 *  distributed without restriction. Modifications to this source
 *  file as permitted in IEEE P1906.1 may also be made and
 *  distributed. All other uses require permission from the IEEE
 *  Standards Department (stds-ipr@ieee.org). All other rights
 *  reserved.
 *
 *  This source file is provided on an AS IS basis.
 *  The IEEE disclaims ANY WARRANTY EXPRESS OR IMPLIED INCLUDING
 *  ANY WARRANTY OF MERCHANTABILITY AND FITNESS FOR USE FOR A
 *  PARTICULAR PURPOSE.
 *  The user of the source file shall indemnify and hold
 *  IEEE harmless from any damages or liability arising out of
 *  the use thereof.
 *
 * Author: Giuseppe Piro - Telematics Lab Research Group
 *                         Politecnico di Bari
 *                         giuseppe.piro@poliba.it
 *                         telematics.poliba.it/piro
 */


#include "ns3/log.h"

#include "p1906-em-specificity.h"
#include "ns3/p1906-specificity.h"
#include "p1906-em-message-carrier.h"
#include "ns3/p1906-net-device.h"
#include "ns3/p1906-perturbation.h"
#include "ns3/p1906-receiver-communication-interface.h"
#include "ns3/p1906-transmitter-communication-interface.h"
#include "p1906-em-perturbation.h"
#include "ns3/mobility-model.h"


namespace ns3 {

NS_LOG_COMPONENT_DEFINE ("P1906EMSpecificity");

TypeId P1906EMSpecificity::GetTypeId (void)
{
  static TypeId tid = TypeId ("ns3::P1906EMSpecificity")
    .SetParent<P1906Specificity> ();
  return tid;
}

P1906EMSpecificity::P1906EMSpecificity ()
{
  NS_LOG_FUNCTION (this << "EM Specificity Component");
}

P1906EMSpecificity::~P1906EMSpecificity ()
{
  NS_LOG_FUNCTION (this);
}

bool
P1906EMSpecificity::CheckRxCompatibility (Ptr<P1906CommunicationInterface> src, Ptr<P1906CommunicationInterface> dst, Ptr<P1906MessageCarrier> message)
{
  NS_LOG_FUNCTION (this);
  Ptr<P1906EMMessageCarrier> m = message->GetObject <P1906EMMessageCarrier>();

  double distances[1000] = {
  		 0.0001, 0.0006004, 0.0011008, 0.0016012, 0.0021016, 0.002602, 0.0031024, 0.0036028, 0.0041032, 0.0046036, 0.005104, 0.0056044, 0.0061048, 0.00660521, 0.00710561, 0.00760601, 0.00810641, 0.00860681, 0.00910721, 0.00960761, 0.010108, 0.0106084, 0.0111088, 0.0116092, 0.0121096, 0.01261, 0.0131104, 0.0136108, 0.0141112, 0.0146116, 0.015112, 0.0156124, 0.0161128, 0.0166132, 0.0171136, 0.017614, 0.0181144, 0.0186148, 0.0191152, 0.0196156, 0.020116, 0.0206164, 0.0211168, 0.0216172, 0.0221176, 0.022618, 0.0231184, 0.0236188, 0.0241192, 0.0246196, 0.02512, 0.0256204, 0.0261208, 0.0266212, 0.0271216, 0.027622, 0.0281224, 0.0286228, 0.0291232, 0.0296236, 0.030124, 0.0306244, 0.0311248, 0.0316252, 0.0321256, 0.032626, 0.0331264, 0.0336268, 0.0341272, 0.0346276, 0.035128, 0.0356284, 0.0361288, 0.0366292, 0.0371296, 0.03763, 0.0381304, 0.0386308, 0.0391312, 0.0396316, 0.040132, 0.0406324, 0.0411328, 0.0416332, 0.0421336, 0.042634, 0.0431344, 0.0436348, 0.0441352, 0.0446356, 0.045136, 0.0456364, 0.0461368, 0.0466372, 0.0471376, 0.047638, 0.0481384, 0.0486388, 0.0491392, 0.0496396, 0.05014, 0.0506404, 0.0511408, 0.0516412, 0.0521416, 0.052642, 0.0531424, 0.0536428, 0.0541432, 0.0546436, 0.055144, 0.0556444, 0.0561448, 0.0566452, 0.0571456, 0.057646, 0.0581464, 0.0586468, 0.0591472, 0.0596476, 0.060148, 0.0606484, 0.0611488, 0.0616492, 0.0621496, 0.0626501, 0.0631505, 0.0636509, 0.0641513, 0.0646517, 0.0651521, 0.0656525, 0.0661529, 0.0666533, 0.0671537, 0.0676541, 0.0681545, 0.0686549, 0.0691553, 0.0696557, 0.0701561, 0.0706565, 0.0711569, 0.0716573, 0.0721577, 0.0726581, 0.0731585, 0.0736589, 0.0741593, 0.0746597, 0.0751601, 0.0756605, 0.0761609, 0.0766613, 0.0771617, 0.0776621, 0.0781625, 0.0786629, 0.0791633, 0.0796637, 0.0801641, 0.0806645, 0.0811649, 0.0816653, 0.0821657, 0.0826661, 0.0831665, 0.0836669, 0.0841673, 0.0846677, 0.0851681, 0.0856685, 0.0861689, 0.0866693, 0.0871697, 0.0876701, 0.0881705, 0.0886709, 0.0891713, 0.0896717, 0.0901721, 0.0906725, 0.0911729, 0.0916733, 0.0921737, 0.0926741, 0.0931745, 0.0936749, 0.0941753, 0.0946757, 0.0951761, 0.0956765, 0.0961769, 0.0966773, 0.0971777, 0.0976781, 0.0981785, 0.0986789, 0.0991793, 0.0996797, 0.10018, 0.10068, 0.101181, 0.101681, 0.102182, 0.102682, 0.103182, 0.103683, 0.104183, 0.104684, 0.105184, 0.105684, 0.106185, 0.106685, 0.107186, 0.107686, 0.108186, 0.108687, 0.109187, 0.109688, 0.110188, 0.110688, 0.111189, 0.111689, 0.11219, 0.11269, 0.11319, 0.113691, 0.114191, 0.114692, 0.115192, 0.115692, 0.116193, 0.116693, 0.117194, 0.117694, 0.118194, 0.118695, 0.119195, 0.119696, 0.120196, 0.120696, 0.121197, 0.121697, 0.122198, 0.122698, 0.123198, 0.123699, 0.124199, 0.1247, 0.1252, 0.125701, 0.126201, 0.126701, 0.127202, 0.127702, 0.128203, 0.128703, 0.129203, 0.129704, 0.130204, 0.130705, 0.131205, 0.131705, 0.132206, 0.132706, 0.133207, 0.133707, 0.134207, 0.134708, 0.135208, 0.135709, 0.136209, 0.136709, 0.13721, 0.13771, 0.138211, 0.138711, 0.139211, 0.139712, 0.140212, 0.140713, 0.141213, 0.141713, 0.142214, 0.142714, 0.143215, 0.143715, 0.144215, 0.144716, 0.145216, 0.145717, 0.146217, 0.146717, 0.147218, 0.147718, 0.148219, 0.148719, 0.149219, 0.14972, 0.15022, 0.150721, 0.151221, 0.151721, 0.152222, 0.152722, 0.153223, 0.153723, 0.154223, 0.154724, 0.155224, 0.155725, 0.156225, 0.156725, 0.157226, 0.157726, 0.158227, 0.158727, 0.159227, 0.159728, 0.160228, 0.160729, 0.161229, 0.161729, 0.16223, 0.16273, 0.163231, 0.163731, 0.164231, 0.164732, 0.165232, 0.165733, 0.166233, 0.166733, 0.167234, 0.167734, 0.168235, 0.168735, 0.169235, 0.169736, 0.170236, 0.170737, 0.171237, 0.171737, 0.172238, 0.172738, 0.173239, 0.173739, 0.174239, 0.17474, 0.17524, 0.175741, 0.176241, 0.176741, 0.177242, 0.177742, 0.178243, 0.178743, 0.179243, 0.179744, 0.180244, 0.180745, 0.181245, 0.181745, 0.182246, 0.182746, 0.183247, 0.183747, 0.184247, 0.184748, 0.185248, 0.185749, 0.186249, 0.186749, 0.18725, 0.18775, 0.188251, 0.188751, 0.189251, 0.189752, 0.190252, 0.190753, 0.191253, 0.191753, 0.192254, 0.192754, 0.193255, 0.193755, 0.194255, 0.194756, 0.195256, 0.195757, 0.196257, 0.196757, 0.197258, 0.197758, 0.198259, 0.198759, 0.199259, 0.19976, 0.20026, 0.200761, 0.201261, 0.201761, 0.202262, 0.202762, 0.203263, 0.203763, 0.204263, 0.204764, 0.205264, 0.205765, 0.206265, 0.206765, 0.207266, 0.207766, 0.208267, 0.208767, 0.209267, 0.209768, 0.210268, 0.210769, 0.211269, 0.211769, 0.21227, 0.21277, 0.213271, 0.213771, 0.214271, 0.214772, 0.215272, 0.215773, 0.216273, 0.216773, 0.217274, 0.217774, 0.218275, 0.218775, 0.219275, 0.219776, 0.220276, 0.220777, 0.221277, 0.221777, 0.222278, 0.222778, 0.223279, 0.223779, 0.224279, 0.22478, 0.22528, 0.225781, 0.226281, 0.226781, 0.227282, 0.227782, 0.228283, 0.228783, 0.229283, 0.229784, 0.230284, 0.230785, 0.231285, 0.231785, 0.232286, 0.232786, 0.233287, 0.233787, 0.234287, 0.234788, 0.235288, 0.235789, 0.236289, 0.236789, 0.23729, 0.23779, 0.238291, 0.238791, 0.239291, 0.239792, 0.240292, 0.240793, 0.241293, 0.241793, 0.242294, 0.242794, 0.243295, 0.243795, 0.244295, 0.244796, 0.245296, 0.245797, 0.246297, 0.246797, 0.247298, 0.247798, 0.248299, 0.248799, 0.249299, 0.2498, 0.2503, 0.250801, 0.251301, 0.251801, 0.252302, 0.252802, 0.253303, 0.253803, 0.254303, 0.254804, 0.255304, 0.255805, 0.256305, 0.256805, 0.257306, 0.257806, 0.258307, 0.258807, 0.259307, 0.259808, 0.260308, 0.260809, 0.261309, 0.261809, 0.26231, 0.26281, 0.263311, 0.263811, 0.264311, 0.264812, 0.265312, 0.265813, 0.266313, 0.266813, 0.267314, 0.267814, 0.268315, 0.268815, 0.269315, 0.269816, 0.270316, 0.270817, 0.271317, 0.271817, 0.272318, 0.272818, 0.273319, 0.273819, 0.274319, 0.27482, 0.27532, 0.275821, 0.276321, 0.276821, 0.277322, 0.277822, 0.278323, 0.278823, 0.279323, 0.279824, 0.280324, 0.280825, 0.281325, 0.281825, 0.282326, 0.282826, 0.283327, 0.283827, 0.284327, 0.284828, 0.285328, 0.285829, 0.286329, 0.286829, 0.28733, 0.28783, 0.288331, 0.288831, 0.289331, 0.289832, 0.290332, 0.290833, 0.291333, 0.291833, 0.292334, 0.292834, 0.293335, 0.293835, 0.294335, 0.294836, 0.295336, 0.295837, 0.296337, 0.296837, 0.297338, 0.297838, 0.298339, 0.298839, 0.299339, 0.29984, 0.30034, 0.300841, 0.301341, 0.301841, 0.302342, 0.302842, 0.303343, 0.303843, 0.304343, 0.304844, 0.305344, 0.305845, 0.306345, 0.306845, 0.307346, 0.307846, 0.308347, 0.308847, 0.309347, 0.309848, 0.310348, 0.310849, 0.311349, 0.311849, 0.31235, 0.31285, 0.313351, 0.313851, 0.314351, 0.314852, 0.315352, 0.315853, 0.316353, 0.316853, 0.317354, 0.317854, 0.318355, 0.318855, 0.319355, 0.319856, 0.320356, 0.320857, 0.321357, 0.321857, 0.322358, 0.322858, 0.323359, 0.323859, 0.324359, 0.32486, 0.32536, 0.325861, 0.326361, 0.326861, 0.327362, 0.327862, 0.328363, 0.328863, 0.329363, 0.329864, 0.330364, 0.330865, 0.331365, 0.331865, 0.332366, 0.332866, 0.333367, 0.333867, 0.334367, 0.334868, 0.335368, 0.335869, 0.336369, 0.336869, 0.33737, 0.33787, 0.338371, 0.338871, 0.339371, 0.339872, 0.340372, 0.340873, 0.341373, 0.341873, 0.342374, 0.342874, 0.343375, 0.343875, 0.344375, 0.344876, 0.345376, 0.345877, 0.346377, 0.346877, 0.347378, 0.347878, 0.348379, 0.348879, 0.349379, 0.34988, 0.35038, 0.350881, 0.351381, 0.351881, 0.352382, 0.352882, 0.353383, 0.353883, 0.354383, 0.354884, 0.355384, 0.355885, 0.356385, 0.356885, 0.357386, 0.357886, 0.358387, 0.358887, 0.359387, 0.359888, 0.360388, 0.360889, 0.361389, 0.361889, 0.36239, 0.36289, 0.363391, 0.363891, 0.364391, 0.364892, 0.365392, 0.365893, 0.366393, 0.366893, 0.367394, 0.367894, 0.368395, 0.368895, 0.369395, 0.369896, 0.370396, 0.370897, 0.371397, 0.371897, 0.372398, 0.372898, 0.373399, 0.373899, 0.374399, 0.3749, 0.3754, 0.375901, 0.376401, 0.376902, 0.377402, 0.377902, 0.378403, 0.378903, 0.379404, 0.379904, 0.380404, 0.380905, 0.381405, 0.381906, 0.382406, 0.382906, 0.383407, 0.383907, 0.384408, 0.384908, 0.385408, 0.385909, 0.386409, 0.38691, 0.38741, 0.38791, 0.388411, 0.388911, 0.389412, 0.389912, 0.390412, 0.390913, 0.391413, 0.391914, 0.392414, 0.392914, 0.393415, 0.393915, 0.394416, 0.394916, 0.395416, 0.395917, 0.396417, 0.396918, 0.397418, 0.397918, 0.398419, 0.398919, 0.39942, 0.39992, 0.40042, 0.400921, 0.401421, 0.401922, 0.402422, 0.402922, 0.403423, 0.403923, 0.404424, 0.404924, 0.405424, 0.405925, 0.406425, 0.406926, 0.407426, 0.407926, 0.408427, 0.408927, 0.409428, 0.409928, 0.410428, 0.410929, 0.411429, 0.41193, 0.41243, 0.41293, 0.413431, 0.413931, 0.414432, 0.414932, 0.415432, 0.415933, 0.416433, 0.416934, 0.417434, 0.417934, 0.418435, 0.418935, 0.419436, 0.419936, 0.420436, 0.420937, 0.421437, 0.421938, 0.422438, 0.422938, 0.423439, 0.423939, 0.42444, 0.42494, 0.42544, 0.425941, 0.426441, 0.426942, 0.427442, 0.427942, 0.428443, 0.428943, 0.429444, 0.429944, 0.430444, 0.430945, 0.431445, 0.431946, 0.432446, 0.432946, 0.433447, 0.433947, 0.434448, 0.434948, 0.435448, 0.435949, 0.436449, 0.43695, 0.43745, 0.43795, 0.438451, 0.438951, 0.439452, 0.439952, 0.440452, 0.440953, 0.441453, 0.441954, 0.442454, 0.442954, 0.443455, 0.443955, 0.444456, 0.444956, 0.445456, 0.445957, 0.446457, 0.446958, 0.447458, 0.447958, 0.448459, 0.448959, 0.44946, 0.44996, 0.45046, 0.450961, 0.451461, 0.451962, 0.452462, 0.452962, 0.453463, 0.453963, 0.454464, 0.454964, 0.455464, 0.455965, 0.456465, 0.456966, 0.457466, 0.457966, 0.458467, 0.458967, 0.459468, 0.459968, 0.460468, 0.460969, 0.461469, 0.46197, 0.46247, 0.46297, 0.463471, 0.463971, 0.464472, 0.464972, 0.465472, 0.465973, 0.466473, 0.466974, 0.467474, 0.467974, 0.468475, 0.468975, 0.469476, 0.469976, 0.470476, 0.470977, 0.471477, 0.471978, 0.472478, 0.472978, 0.473479, 0.473979, 0.47448, 0.47498, 0.47548, 0.475981, 0.476481, 0.476982, 0.477482, 0.477982, 0.478483, 0.478983, 0.479484, 0.479984, 0.480484, 0.480985, 0.481485, 0.481986, 0.482486, 0.482986, 0.483487, 0.483987, 0.484488, 0.484988, 0.485488, 0.485989, 0.486489, 0.48699, 0.48749, 0.48799, 0.488491, 0.488991, 0.489492, 0.489992, 0.490492, 0.490993, 0.491493, 0.491994, 0.492494, 0.492994, 0.493495, 0.493995, 0.494496, 0.494996, 0.495496, 0.495997, 0.496497, 0.496998, 0.497498, 0.497998, 0.498499, 0.498999, 0.4995, 0.5,
  		 };

  double molecularnoise[1000][11] = {
   {
  131.214, 156.134, 156.134, 163.643, 163.643, 170.786, 190.19, 196.037, 206.889, 221.261, 206.889
   },
  {
  298.618, 305.378, 305.378, 306.577, 306.577, 307.465, 308.971, 309.238, 309.582, 309.83, 309.582
   },
  {
  309.275, 309.861, 309.861, 309.92, 309.92, 309.954, 309.991, 309.995, 309.998, 310, 309.998
   },
  {
  309.954, 309.996, 309.996, 309.998, 309.998, 309.999, 310, 310, 310, 310, 310
   },
  {
  309.997, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },
  {
  310, 310, 310, 310, 310, 310, 310, 310, 310, 310, 310
   },

   };

  Ptr<P1906EMPerturbation> perturbation = GetP1906CommunicationInterface ()->
		  GetP1906TransmitterCommunicationInterface ()->GetP1906Perturbation ()->
		  GetObject<P1906EMPerturbation> ();

  if (perturbation->GetBandwidth() == m->GetBandwidth() &&
      perturbation->GetSubChannel() == m->GetSubChannel() &&
      perturbation->GetCentralFrequency() == m->GetCentralFrequency ())
    {
	  NS_LOG_FUNCTION (this << "compatibility OK --> verify the respect of the Shannon bound");

	  double transmissionRate = 1. / m->GetPulseInterval ().GetSeconds ();

	  Ptr<MobilityModel> srcMobility = src->GetP1906NetDevice ()->GetNode ()->GetObject<MobilityModel> ();
	  Ptr<MobilityModel> dstMobility = dst->GetP1906NetDevice ()->GetNode ()->GetObject<MobilityModel> ();
	  double distance = dstMobility->GetDistanceFrom (srcMobility);

	  NS_LOG_FUNCTION (this << "[distance,txRate]" << distance << transmissionRate);

	  double channelCapacity = 0;

	  int index_d;
	  if (distance <= distances [0])
		index_d = 0;
	  else if (distance >= distances [999])
		  index_d = 999;
	  else
	    {
		  index_d = 0;
		  for (int i = 1; i < 1000; i++)
		    {
			  if (distances [i] > distance)
			    {
				  index_d = i-1;
				  i=1000;
			    }
		    }
	    }

	  NS_LOG_FUNCTION (this << "[index,distance]" << index_d << distances [index_d]);

	  Ptr<P1906EMMessageCarrier> m = message->GetObject <P1906EMMessageCarrier> ();
	  Ptr<SpectrumValue> sv = m->GetSpectrumValue ();
	  for (int i=0; i<11; i++)
	    {
		  double power = (*sv)[i] * perturbation->GetSubChannel();
		  double boltzman = 1.380658e-23;
		  double molecularNoisePower =  boltzman *molecularnoise[index_d][i];
		  double sinr_i = power/molecularNoisePower;
		  channelCapacity += m->GetSubChannel() * log(1 + sinr_i)/log(2);
		  NS_LOG_FUNCTION (this << "[i,prx, mol,sinr,capacity]" << i << power << molecularNoisePower << sinr_i << channelCapacity);
	    }


	  NS_LOG_FUNCTION (this << "testcapacity: [distance, txRate, channelCapacity]" << distance << transmissionRate << channelCapacity);

	  if (channelCapacity >= transmissionRate)
	    {
		  NS_LOG_FUNCTION (this << "Shannon bound has been respected");
		  return true;
	    }
	  else
	    {
		  NS_LOG_FUNCTION (this << "Shannon bound has NOT been respected --> transmission failed");
		  return false;
	    }
    }
  else
    {
	  NS_LOG_FUNCTION (this << "check compatibility failed");
	  return false;
    }
}

} // namespace ns3
